<?php

namespace App\Modules\TempApplication\Migrations\tmpPayTransaction;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TmpPayTransaction extends Model 
{

    protected $table = 'tmp_pay_transactions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function reciver()
    {
        return $this->belongsTo('Customer', 'reciver_id');
    }

    public function payCustomer()
    {
        return $this->belongsTo('PayCustomer', 'pay_customer_id');
    }

}